﻿Option Strict Off
Imports System.Data.Odbc

Public Class frmPerbandinganBerpasangan
    Dim jlhKriteria As Integer = 0
    Dim strKriteria(), strkode_Kriteria() As String
    Dim jlhBulat As Integer = 3

    Private Sub frmPerbandinganBerpasangan_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        loading()
    End Sub

    Sub loading()
        Koneksi()
        Dim rs As OdbcDataReader
        Dim cmd As OdbcCommand

        Dim lstKriteria As New List(Of String)
        Dim lstkode_Kriteria As New List(Of String)

        cmd = New OdbcCommand("select kode_kriteria,nama_kriteria from `tbkriteria` order by `kode_kriteria` asc", Conn)
        rs = cmd.ExecuteReader
        If Not rs.HasRows Then
            MsgBox("Data Tidak Ada!")
            Exit Sub
        End If
        dg1.Columns.Clear()

        'buat matriks perbandingan berpasangan
        While rs.Read
            lstKriteria.Add(rs("nama_kriteria"))
            lstkode_Kriteria.Add(rs("kode_kriteria"))
            dg1.Columns.Add(rs("nama_kriteria"), rs("nama_kriteria"))
        End While
        strKriteria = lstKriteria.ToArray
        strkode_Kriteria = lstkode_Kriteria.ToArray
        jlhKriteria = lstKriteria.Count
        rs.Close()
        dg1.Rows.Add(jlhKriteria + 1)
        For i = 0 To jlhKriteria - 1
            Dim hd As New DataGridViewRowHeaderCell
            dg1.Rows(i).HeaderCell.Value = dg1.Columns(i).HeaderText
        Next
        dg1.Rows(jlhKriteria).HeaderCell.Value = "Jumlah"

        'buat matriks nilai kriteria
        dg2.Columns.Clear()
        For i = 0 To jlhKriteria - 1
            dg2.Columns.Add("", lstKriteria(i))
        Next

        dg2.Rows.Add(jlhKriteria + 1)
        For i = 0 To jlhKriteria - 1
            dg2.Rows(i).HeaderCell.Value = dg2.Columns(i).HeaderText
        Next
        dg2.Rows(jlhKriteria).HeaderCell.Value = "Jumlah"
        dg2.Columns.Add("", "Jumlah Baris")
        dg2.Columns.Add("", "Priority Vector Normalisasi")

        ''buat matriks penjumlahan tiap baris   
        Dim lstKriteria2 As New List(Of String)
        cmd = New OdbcCommand("select `nama_kriteria` from `tbkriteria` order by `kode_kriteria` asc", Conn)
        rs = cmd.ExecuteReader
        If Not rs.HasRows Then
            MsgBox("Data Tidak Ada!")
            Exit Sub
        End If
        dg3.Columns.Clear()
        While rs.Read
            lstKriteria2.Add(rs("nama_kriteria"))
            dg3.Columns.Add(rs("nama_kriteria"), rs("nama_kriteria"))
        End While
        strKriteria = lstKriteria2.ToArray
        jlhKriteria = lstKriteria2.Count
        rs.Close()
        dg3.Rows.Add(jlhKriteria)
        For i = 0 To jlhKriteria - 1
            Dim hd As New DataGridViewRowHeaderCell
            dg3.Rows(i).HeaderCell.Value = dg3.Columns(i).HeaderText
        Next
        dg3.Columns.Add("", "Jumlah Baris")

        'buat matriks rasio konsistensi
        dg4.Columns.Clear()
        dg4.Columns.Add("", "Jumlah Baris")
        dg4.Columns.Add("", "Priority Vector Normalisasi")
        dg4.Columns.Add("", "Hasil")
        dg4.Rows.Add(jlhKriteria + 1)
        For i = 0 To jlhKriteria - 1
            dg4.Rows(i).HeaderCell.Value = lstKriteria(i)
        Next
        dg4.Rows(jlhKriteria).HeaderCell.Value = "Jumlah"

        isiMatriksPerbandinganBerpsangan()
        For Each col As DataGridViewColumn In dg1.Columns
            col.SortMode = DataGridViewColumnSortMode.Programmatic
        Next

        For Each col As DataGridViewColumn In dg2.Columns
            col.SortMode = DataGridViewColumnSortMode.Programmatic
        Next

        For Each col As DataGridViewColumn In dg4.Columns
            col.SortMode = DataGridViewColumnSortMode.Programmatic
        Next
    End Sub

    Sub isiMatriksPerbandinganBerpsangan()
        Dim cmd As OdbcCommand
        Dim rs As OdbcDataReader
        For i = 0 To jlhKriteria - 1
            dg1.Item(i, i).Value = 1
        Next
        cmd = New OdbcCommand("select * from `tbpberpasangan` where `kode_kriteria`='all'", Conn)
        rs = cmd.ExecuteReader
        If rs.HasRows Then
            While rs.Read
                If Val(rs("rowIndex")) > Val(rs("colIndex")) Then
                    dg1.Item(rs("colIndex"), rs("rowIndex")).value = Format(rs("nilai"), "0.00")
                    ' dg1.Item(rs("colIndex"), rs("rowIndex")).value = Val(rs("nilai"))
                Else
                    dg1.Item(rs("colIndex"), rs("rowIndex")).value = Val(rs("nilai"))
                End If
            End While
            rs.Close()
            hitungMatriksPerbandinganBerpasangan()
            hitungMatriksNilaiKriteria()
            hitungMatriksPenjumlahanTiapBaris()
            hitungMatriksRasioKonsistensi()
            hitungLainya()
        Else
            rs.Close()
            For i = 0 To jlhKriteria - 1
                dg1.Item(i, i).Value = 1
            Next
        End If
    End Sub

    Private Sub btnProses_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnProses.Click
        hitungMatriksPerbandinganBerpasangan()
        hitungMatriksNilaiKriteria()
        hitungMatriksPenjumlahanTiapBaris() 'ttp
        hitungMatriksRasioKonsistensi()
        hitungLainya()
    End Sub

    Sub hitungMatriksPerbandinganBerpasangan()
        For i = 0 To jlhKriteria - 1
            For j = 0 To jlhKriteria - 1
                If i > j Then
                    dg1.Item(j, i).Value = Math.Round(Val(dg1.Item(j, j).Value) / Val(dg1.Item(i, j).Value), jlhBulat)
                End If
            Next
        Next

        For i = 0 To jlhKriteria - 1
            Dim jlh As Double = 0
            For j = 0 To jlhKriteria - 1
                jlh += Val(dg1.Item(i, j).Value)
            Next
            dg1.Item(i, jlhKriteria).Value = Math.Round(jlh, jlhBulat)
        Next
        dg1.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        For k As Integer = 0 To jlhKriteria - 1
            ' dg1.Columns(k).DefaultCellStyle.Format = "0.000"
            dg1.Columns(k).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        Next
    End Sub

    Sub hitungMatriksNilaiKriteria()
        For i = 0 To jlhKriteria - 1
            For j = 0 To jlhKriteria - 1
                dg2.Item(i, j).Value = Math.Round(Val(dg1.Item(i, j).Value) / Val(dg1.Item(i, jlhKriteria).Value), jlhBulat)
            Next
        Next

        For row = 0 To jlhKriteria - 1
            Dim jlh As Double = 0
            For kol = 0 To jlhKriteria - 1
                jlh += Val(dg2.Item(kol, row).Value)
            Next
            dg2.Item(jlhKriteria, row).Value = Math.Round(jlh, jlhBulat)
        Next

        For row = 0 To jlhKriteria - 1
            dg2.Item(jlhKriteria + 1, row).Value = Math.Round(Val(dg2.Item(jlhKriteria, row).Value) / jlhKriteria, jlhBulat)
        Next

        For i As Integer = 0 To jlhKriteria
            Dim jlh As Double = 0
            For j As Integer = 0 To jlhKriteria - 1
                jlh += dg2.Item(i, j).Value
            Next
            dg2.Item(i, jlhKriteria).Value = Math.Round(jlh, jlhBulat)
        Next
        dg2.ReadOnly = True
        dg2.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        dg2.DefaultCellStyle.ForeColor = Color.Blue
        dg2.RowHeadersDefaultCellStyle.BackColor = Color.DeepPink
        dg2.AlternatingRowsDefaultCellStyle.BackColor = Color.Yellow
        dg2.SelectionMode = DataGridViewSelectionMode.FullRowSelect
        For k As Integer = 0 To jlhKriteria + 1
            dg2.Columns(k).DefaultCellStyle.Format = "0.000"
            dg2.Columns(k).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        Next
    End Sub

    Sub hitungMatriksPenjumlahanTiapBaris()
        For row = 0 To jlhKriteria - 1
            Dim jlh As Double = 0
            For kol = 0 To jlhKriteria - 1
                dg3.Item(kol, row).Value = Math.Round(Val(dg2.Item(jlhKriteria + 1, row).Value) * Val(dg1.Item(kol, row).Value), jlhBulat)
                jlh += Math.Round(Val(dg2.Item(jlhKriteria + 1, row).Value) * Val(dg1.Item(kol, row).Value), jlhBulat)
            Next
            dg3.Item(jlhKriteria, row).Value = jlh
        Next
        dg3.ReadOnly = True
        dg3.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        dg3.DefaultCellStyle.ForeColor = Color.Blue
        dg3.RowHeadersDefaultCellStyle.BackColor = Color.DeepPink
        dg3.AlternatingRowsDefaultCellStyle.BackColor = Color.Yellow
        dg3.SelectionMode = DataGridViewSelectionMode.FullRowSelect
        For k As Integer = 0 To jlhKriteria
            dg3.Columns(k).DefaultCellStyle.Format = "0.000"
            dg3.Columns(k).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        Next
    End Sub

    Sub hitungMatriksRasioKonsistensi()
        Dim jlh As Double = 0
        For row = 0 To jlhKriteria - 1
            dg4.Item(0, row).Value = Val(dg3.Item(jlhKriteria, row).Value)
            dg4.Item(1, row).Value = Val(dg2.Item(jlhKriteria + 1, row).Value)
            dg4.Item(2, row).Value = Val(dg4.Item(0, row).Value) + Val(dg4.Item(1, row).Value)
            jlh += Val(dg4.Item(2, row).Value)
        Next
        dg4.Item(2, jlhKriteria).Value = Math.Round(jlh, jlhBulat)
        jlh = 0
        dg4.ReadOnly = True
        dg4.DefaultCellStyle.ForeColor = Color.Blue
        dg4.RowHeadersDefaultCellStyle.BackColor = Color.DeepPink
        dg4.AlternatingRowsDefaultCellStyle.BackColor = Color.Yellow
        dg4.SelectionMode = DataGridViewSelectionMode.FullRowSelect
        dg4.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        For k As Integer = 0 To 2
            ' dg4.Columns(k).Width = 70
            dg4.Columns(k).DefaultCellStyle.Format = "0.000"
            dg4.Columns(k).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter
        Next
    End Sub

    Sub hitungLainya()
        nMaks.Text = "λ Maks  : " & Format(Math.Round(Val(dg4.Item(2, jlhKriteria).Value) / jlhKriteria, jlhBulat), "0.000")
        ik.Text = "Indeks Konsistensi : " & Format(Math.Round(((Val(dg4.Item(2, jlhKriteria).Value) / jlhKriteria) - jlhKriteria) / jlhKriteria, jlhBulat), "0.000")
        rk.Text = "Rasio Konsistensi : " & Format(Math.Round((((Val(dg4.Item(2, jlhKriteria).Value) / jlhKriteria) - jlhKriteria) / jlhKriteria) / NilaiIndeksRandom(jlhKriteria), jlhBulat), "0.000")
        Dim rc As Double = Val(Format(Math.Round((((Val(dg4.Item(2, jlhKriteria).Value) / jlhKriteria) - jlhKriteria) / jlhKriteria) / NilaiIndeksRandom(jlhKriteria), jlhBulat), "0.000"))
        If rc < 0.1 Then
            k.Text = "Konsistensi : Konsisten"
        Else
            k.Text = "Konsistensi : Tidak Konsisten"
        End If
    End Sub

    Private Sub btnSimpan_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSimpan.Click
        Dim cmd As OdbcCommand
        Dim cBulat, cBulat2 As String
        cmd = New OdbcCommand("delete from `tbpberpasangan` where `kode_kriteria`='all'", Conn)
        cmd.ExecuteNonQuery()

        For i = 0 To jlhKriteria - 1
            For j = 0 To jlhKriteria - 1
                cBulat = Replace(dg1.Item(j, i).Value, ",", ".")
                cmd = New OdbcCommand("insert into `tbpberpasangan` values('all','" & j & "','" & i & "','" & cBulat & "')", Conn)
                cmd.ExecuteNonQuery()
            Next
        Next

        cmd = New OdbcCommand("delete from `tbprioritas` where `kode_kriteria`='all'", Conn)
        cmd.ExecuteNonQuery()

        For i = 0 To jlhKriteria - 1
            cBulat2 = Replace(Val(dg2.Item(jlhKriteria + 1, i).Value), ",", ".")
            cmd = New OdbcCommand("insert into `tbprioritas` values('all','" & strkode_Kriteria(i) & "','" & cBulat2 & "')", Conn)
            cmd.ExecuteNonQuery()
        Next
        MsgBox("Data Tersimpan")
    End Sub

    Private Sub ik_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ik.Click

    End Sub

    Private Sub dg1_CellBeginEdit(ByVal sender As Object, ByVal e As System.Windows.Forms.DataGridViewCellCancelEventArgs) Handles dg1.CellBeginEdit
        If e.ColumnIndex > e.RowIndex Then
            e.Cancel = False
            If Val(dg1.Item(e.ColumnIndex, e.RowIndex).Value) < 1 Then
                dg1.Item(e.ColumnIndex, e.RowIndex).Value = 1
            End If
        Else
            e.Cancel = True
        End If
    End Sub

    Private Sub dg1_CellEndEdit(ByVal sender As Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs) Handles dg1.CellEndEdit
        If e.ColumnIndex > e.RowIndex Then
            If Val(dg1.Item(e.ColumnIndex, e.RowIndex).Value) < 1 Then
                dg1.Item(e.ColumnIndex, e.RowIndex).Value = 1
            End If        
        End If
    End Sub

    Private Sub dg1_CellContentClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs) Handles dg1.CellContentClick

    End Sub

    Private Sub btnTutup_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTutup.Click
        Me.Dispose()
    End Sub

    Private Sub dg1_EditingControlShowing(ByVal sender As Object, ByVal e As System.Windows.Forms.DataGridViewEditingControlShowingEventArgs) Handles dg1.EditingControlShowing
        If e.Control.GetType.ToString() = "System.Windows.Forms.DataGridViewTextBoxEditingControl" Then
            Dim c As DataGridViewTextBoxEditingControl = CType(e.Control, DataGridViewTextBoxEditingControl)
            RemoveHandler c.KeyPress, AddressOf GridViewTextBox_KeyPress
            AddHandler c.KeyPress, AddressOf GridViewTextBox_KeyPress
        End If
    End Sub
    Private Sub GridViewTextBox_KeyPress(ByVal sender As Object, ByVal ex As KeyPressEventArgs)
        ' If dg1.CurrentCell.ColumnIndex = 1 Then
        If ((Asc(ex.KeyChar) < 48 Or Asc(ex.KeyChar) > 57) And Asc(ex.KeyChar) <> 8) Then
            ex.Handled = True
        End If
        ' End If
    End Sub

    Private Sub dg4_CellContentClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs) Handles dg4.CellContentClick

    End Sub
End Class